/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.SRCEntry;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt32;

public class PIRefCodeList {
    private static final int NUM_VALID_PARMS = 6;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_numEntriesString;
    private String m_filter;
    private String m_format;
    private boolean m_header;
    private int m_numEntries = 0;
    private String[] m_filterPartIds = null;
    private String[] m_filterPartNames = null;
    private HashMap m_validParms = new HashMap(13, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private String m_delimiter = ",";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIRefCodeList(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-n", null);
        this.m_validParms.put("--filter", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
    }

    private void doSysRefCodeList() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"refcode_num", "refcode", "word2", "word3", "word4", "word5", "word6", "word7", "word8", "word9", "fru_call_out_loc_codes"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector vector = new Vector();
        if (this.m_numEntries <= 1) {
            SRCEntry sRCEntry = this.m_CECClient.getCurrentSRCInfo();
            vector.addElement(sRCEntry);
        } else {
            vector = this.m_CECClient.getMultipleSRCInfo(0L, this.m_numEntries);
        }
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doPartitionRefCodeList() throws PIHscClientException {
        Object object;
        String[] stringArray;
        Object[] objectArray = null;
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>();
        String[] stringArray2 = new String[]{"lpar_name", "lpar_id", "time_stamp", "refcode", "word2", "word3", "word4", "word5", "word6", "word7", "word8", "word9", "fru_call_out_loc_codes"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        if (this.m_filterPartIds != null) {
            objectArray = this.m_filterPartIds;
            bl = true;
        } else if (this.m_filterPartNames != null) {
            objectArray = this.m_filterPartNames;
        } else {
            Vector vector2 = this.m_CECClient.getPartitionNames();
            objectArray = new String[vector2.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                object = (String[])vector2.elementAt(i);
                objectArray[i] = object[0];
            }
            bl = true;
            Arrays.sort(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            PIHSCLPARClient pIHSCLPARClient = null;
            if (bl) {
                try {
                    pIHSCLPARClient = pIHSCClientObjectFactory.createLPARClient(this.m_managedSystem, (String)objectArray[i], true);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    pIHSCLPARClient = pIHSCClientObjectFactory.createLPARClient(this.m_managedSystem, (String)objectArray[i], false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (pIHSCLPARClient != null) {
                UnsignedInt32 unsignedInt32;
                Vector vector3;
                object = pIHSCLPARClient.getCurrentSRCInfo();
                if (object == null) continue;
                vector.add(object);
                if (this.m_numEntries <= 1 || (vector3 = pIHSCLPARClient.getMultipleSRCInfo((unsignedInt32 = new UnsignedInt32(((SRCEntry)object).getSrcSeqNum())).longValue() - 1L, this.m_numEntries - 1)) == null) continue;
                vector.addAll(vector3);
                continue;
            }
            if (this.m_filterPartIds == null && this.m_filterPartNames == null) continue;
            object = new String[]{objectArray[i]};
            if (bl) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", (String[])object, null);
            }
            throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", (String[])object, null);
        }
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if ("sys".equals(this.m_resourceType)) {
            if (n == 254 || n == 241 || n == 242 || n == 250) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
            }
            this.doSysRefCodeList();
        } else {
            if (n != 17 && n != 1) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
            }
            this.doPartitionRefCodeList();
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (this.m_resourceType == null || !"sys".equals(this.m_resourceType) && !"lpar".equals(this.m_resourceType)) {
            string = string + ", -r";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_numEntriesString != null) {
            try {
                this.m_numEntries = Integer.parseInt(this.m_numEntriesString);
                if (this.m_numEntries < 1) {
                    string = "-n";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = "-n";
            }
            if (string.length() > 0) {
                String[] stringArray = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
        }
        if (this.m_filter != null) {
            if ("sys".equals(this.m_resourceType)) {
                String[] stringArray = new String[]{"--filter", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
            String[] stringArray = new String[]{"lpar_ids", "lpar_names"};
            HashMap hashMap = PIHMCCommandUtils.parseFilter(this.m_filter, stringArray);
            String string2 = (String)hashMap.get("lpar_ids");
            String string3 = (String)hashMap.get("lpar_names");
            if (string2 != null && string3 != null) {
                String[] stringArray2 = new String[]{"lpar_ids, lpar_names"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_FILTER_NAMES", stringArray2, null);
            }
            if (string2 != null) {
                this.m_filterPartIds = PIHMCCommandUtils.parseList(string2, ",");
            }
            if (string3 != null) {
                this.m_filterPartNames = PIHMCCommandUtils.parseList(string3, ",");
            }
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_numEntriesString = (String)hashMap.get("-n");
        this.m_filter = (String)hashMap.get("--filter");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSREFCODE_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIRefCodeList pIRefCodeList = new PIRefCodeList(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIRefCodeList.m_validParms);
            pIRefCodeList.mapParameters(hashMap);
            pIRefCodeList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

